<?php $__env->startSection('css'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
    <h1 class="page-title">
        <i class="<?php echo e($dataType->icon); ?>"></i> <?php if(isset($dataTypeContent->id)): ?><?php echo e('Edit'); ?><?php else: ?><?php echo e('New'); ?><?php endif; ?> <?php echo e($dataType->display_name_singular); ?>

    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-content container-fluid">
        <div class="row">
            <div class="col-md-12">

                <div class="panel panel-bordered">

                    <div class="panel-heading">
                        <h3 class="panel-title"><?php if(isset($dataTypeContent->id)): ?><?php echo e('Edit'); ?><?php else: ?><?php echo e('Add New'); ?><?php endif; ?> <?php echo e($dataType->display_name_singular); ?></h3>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <form role="form"
                          action="<?php if(isset($dataTypeContent->id)): ?><?php echo e(route('voyager.'.$dataType->slug.'.update', $dataTypeContent->id)); ?><?php else: ?><?php echo e(route('voyager.'.$dataType->slug.'.store')); ?><?php endif; ?>"
                          method="POST" enctype="multipart/form-data">

                        <!-- PUT Method if we are editing -->
                        <?php if(isset($dataTypeContent->id)): ?>
                            <?php echo e(method_field("PUT")); ?>

                        <?php endif; ?>

                        <!-- CSRF TOKEN -->
                        <?php echo e(csrf_field()); ?>


                        <div class="panel-body">

                            <?php if(count($errors) > 0): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php $__currentLoopData = $dataType->addRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                <div class="form-group">
                                    <label for="name"><?php echo e($row->display_name); ?></label>

                                    <?php if($row->type == "text"): ?>
                                        <input type="text" class="form-control" name="<?php echo e($row->field); ?>"
                                               placeholder="<?php echo e($row->display_name); ?>"
                                               value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">
                                    <?php elseif($row->type == "password"): ?>
                                        <?php if(isset($dataTypeContent->{$row->field})): ?>
                                            <br>
                                            <small>Leave empty to keep the same</small>
                                        <?php endif; ?>
                                        <input type="password" class="form-control" name="<?php echo e($row->field); ?>" value="">
                                    <?php elseif($row->type == "text_area"): ?>
                                        <textarea class="form-control"
                                                  name="<?php echo e($row->field); ?>"><?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?></textarea>
                                    <?php elseif($row->type == "rich_text_box"): ?>
                                        <textarea class="form-control richTextBox"
                                                  name="<?php echo e($row->field); ?>"><?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?></textarea>
                                    <?php elseif($row->type == "image" || $row->type == "file"): ?>
                                        <?php if($row->type == "image" && isset($dataTypeContent->{$row->field})): ?>
                                            <img src="<?php echo e(Voyager::image( $dataTypeContent->{$row->field} )); ?>"
                                                 style="width:200px; height:auto; clear:both; display:block; padding:2px; border:1px solid #ddd; margin-bottom:10px;">
                                        <?php elseif($row->type == "file" && isset($dataTypeContent->{$row->field})): ?>
                                            <div class="fileType"><?php echo e($dataTypeContent->{$row->field}); ?> }}</div>
                                        <?php endif; ?>
                                        <input type="file" name="<?php echo e($row->field); ?>">
                                    <?php elseif($row->type == "select_dropdown"): ?>
                                        <?php $options = json_decode($row->details); ?>
                                        <?php $selected_value = (isset($dataTypeContent->{$row->field}) && !empty(old($row->field,
                                                        $dataTypeContent->{$row->field}))) ? old($row->field,
                                                $dataTypeContent->{$row->field}) : old($row->field); ?>
                                        <select class="form-control" name="<?php echo e($row->field); ?>">
                                            <?php $default = (isset($options->default) && !isset($dataTypeContent->{$row->field})) ? $options->default : NULL; ?>
                                            <?php if(isset($options->options)): ?>
                                                <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                    <option value="<?php echo e($key); ?>" <?php if($default == $key && $selected_value === NULL): ?><?php echo e('selected="selected"'); ?><?php endif; ?> <?php if($selected_value == $key): ?><?php echo e('selected="selected"'); ?><?php endif; ?>><?php echo e($option); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                            <?php endif; ?>
                                        </select>

                                    <?php elseif($row->type == "radio_btn"): ?>
                                        <?php $options = json_decode($row->details); ?>
                                        <?php $selected_value = (isset($dataTypeContent->{$row->field}) && !empty(old($row->field,
                                                        $dataTypeContent->{$row->field}))) ? old($row->field,
                                                $dataTypeContent->{$row->field}) : old($row->field); ?>
                                        <?php $default = (isset($options->default) && !isset($dataTypeContent->{$row->field})) ? $options->default : NULL; ?>
                                        <ul class="radio">
                                            <?php if(isset($options->options)): ?>
                                                <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                    <li>
                                                        <input type="radio" id="option-<?php echo e($key); ?>"
                                                               name="<?php echo e($row->field); ?>"
                                                               value="<?php echo e($key); ?>" <?php if($default == $key && $selected_value === NULL): ?><?php echo e('checked'); ?><?php endif; ?> <?php if($selected_value == $key): ?><?php echo e('checked'); ?><?php endif; ?>>
                                                        <label for="option-<?php echo e($key); ?>"><?php echo e($option); ?></label>
                                                        <div class="check"></div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                            <?php endif; ?>
                                        </ul>

                                    <?php elseif($row->type == "checkbox"): ?>

                                        <br>
                                        <?php $options = json_decode($row->details); ?>
                                        <?php $checked = (isset($dataTypeContent->{$row->field}) && old($row->field,
                                                        $dataTypeContent->{$row->field}) == 1) ? true : old($row->field); ?>
                                        <?php if(isset($options->on) && isset($options->off)): ?>
                                            <input type="checkbox" name="<?php echo e($row->field); ?>" class="toggleswitch"
                                                   data-on="<?php echo e($options->on); ?>" <?php if($checked): ?> checked
                                                   <?php endif; ?> data-off="<?php echo e($options->off); ?>">
                                        <?php else: ?>
                                            <input type="checkbox" name="<?php echo e($row->field); ?>" class="toggleswitch"
                                                   <?php if($checked): ?> checked <?php endif; ?>>
                                        <?php endif; ?>

                                    <?php endif; ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

                            <label for="permission">Permissions</label><br>
                            <a href="#" class="permission-select-all">Select All</a> / <a href="#"  class="permission-deselect-all">Deselect All</a>
                            <ul class="permissions checkbox">
                                <?php
                                    $role_permissions = (isset($dataTypeContent)) ? $dataTypeContent->permissions->pluck('key')->toArray() : [];
                                ?>
                                <?php $__currentLoopData = TCG\Voyager\Models\Permission::all()->groupBy('table_name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table => $permission): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                    <li>
                                        <input type="checkbox" id="<?php echo e($table); ?>" class="permission-group">
                                        <label for="<?php echo e($table); ?>"><strong><?php echo e(ucwords($table)); ?></strong></label>
                                        <ul>
                                            <?php $__currentLoopData = $permission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                <li>
                                                    <input type="checkbox" id="permission-<?php echo e($perm->id); ?>" name="permissions[]" class="the-permission" value="<?php echo e($perm->id); ?>" <?php if(in_array($perm->key, $role_permissions)): ?> checked <?php endif; ?>>
                                                    <label for="permission-<?php echo e($perm->id); ?>"><?php echo e(title_case(str_replace('_', ' ', $perm->key))); ?></label>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                        </ul>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                            </ul>
                        </div><!-- panel-body -->
                        <div class="panel-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>

                    <iframe id="form_target" name="form_target" style="display:none"></iframe>
                    <form id="my_form" action="<?php echo e(route('voyager.upload')); ?>" target="form_target" method="post"
                          enctype="multipart/form-data" style="width:0;height:0;overflow:hidden">
                        <?php echo e(csrf_field()); ?>

                        <input name="image" id="upload_file" type="file"
                               onchange="$('#my_form').submit();this.value='';">
                        <input type="hidden" name="type_slug" id="type_slug" value="<?php echo e($dataType->slug); ?>">
                    </form>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $('document').ready(function () {
            $('.toggleswitch').bootstrapToggle();

            $('.permission-group').on('change', function(){
                $(this).siblings('ul').find("input[type='checkbox']").prop('checked', this.checked);
            });

            $('.permission-select-all').on('click', function(){
                $('ul.permissions').find("input[type='checkbox']").prop('checked', true);
                return false;
            });

            $('.permission-deselect-all').on('click', function(){
                $('ul.permissions').find("input[type='checkbox']").prop('checked', false);
                return false;
            });

            function parentChecked(){
                $('.permission-group').each(function(){
                    var allChecked = true;
                    $(this).siblings('ul').find("input[type='checkbox']").each(function(){
                        if(!this.checked) allChecked = false;
                    });
                    $(this).prop('checked', allChecked);
                });
            }

            parentChecked();

            $('.the-permission').on('change', function(){
                parentChecked();
            });
        });
    </script>
    <script src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/tinymce/tinymce.min.js"></script>
    <script src="<?php echo e(config('voyager.assets_path')); ?>/js/voyager_tinymce.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>