<!DOCTYPE html>
<html>
<head>
    
    <title><?php echo $__env->yieldContent('page_title',Voyager::setting('admin_title') . " - " . Voyager::setting('admin_description')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <link href='https://fonts.googleapis.com/css?family=Roboto+Condensed:300,400|Lato:300,400,700,900' rel='stylesheet'
          type='text/css'>

    <!-- CSS Libs -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/animate.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/bootstrap-switch.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/checkbox3.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/dataTables.bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/select2.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/toastr.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/bootstrap-toggle.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/js/icheck/icheck.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.css">
    <!-- CSS App -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/themes/flat-blue.css">

    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Roboto:300,400,500,300italic">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(config('voyager.assets_path')); ?>/images/logo-icon.png" type="image/x-icon">

    <!-- CSS Fonts -->
    <link rel="stylesheet" href="<?php echo e(config('voyager.assets_path')); ?>/fonts/voyager/styles.css">
    <script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.min.js"></script>
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.0/themes/smoothness/jquery-ui.css">
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.0/jquery-ui.min.js"></script>
    <script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/vue.min.js"></script>

    <?php echo $__env->yieldContent('css'); ?>

    <!-- Voyager CSS -->
    <link rel="stylesheet" href="<?php echo e(config('voyager.assets_path')); ?>/css/voyager.css">

    <?php echo $__env->yieldContent('head'); ?>

</head>

<body class="flat-blue">

<div id="voyager-loader">
    <?php $admin_loader_img = Voyager::setting('admin_loader', ''); ?>
    <?php if($admin_loader_img == ''): ?>
        <img src="<?php echo e(config('voyager.assets_path') . '/images/logo-icon.png'); ?>" alt="Voyager Loader">
    <?php else: ?>
        <img src="<?php echo e(Voyager::image($admin_loader_img)); ?>" alt="Voyager Loader">
    <?php endif; ?>
</div>

<?php
$user_avatar = Voyager::image(Auth::user()->avatar);
if ((substr(Auth::user()->avatar, 0, 7) == 'http://') || (substr(Auth::user()->avatar, 0, 8) == 'https://')) {
    $user_avatar = Auth::user()->avatar;
}
$menuExpanded = isset($_COOKIE['expandedMenu']) && $_COOKIE['expandedMenu'] == 1;
?>

<div class="app-container <?php if($menuExpanded): ?> expanded <?php endif; ?> ">
    <div class="row content-container">
        <?php echo $__env->make('voyager::dashboard.navbar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->make('voyager::dashboard.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <!-- Main Content -->
        <div class="container-fluid">
            <div class="side-body padding-top">
                <?php echo $__env->yieldContent('page_header'); ?>
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>
</div>
<footer class="app-footer">
    <div class="site-footer-right">
        <?php if(rand(1,100) == 100): ?>
            <i class="voyager-rum-1"></i> Made with rum and even more rum
        <?php else: ?>
            Made with <i class="voyager-heart"></i> by <a href="http://thecontrolgroup.com" target="_blank">The Control Group</a>
        <?php endif; ?>
        - <?php echo e(Voyager::getVersion()); ?>

    </div>
</footer>
<!-- Javascript Libs -->

<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/bootstrap-switch.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.matchHeight-min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/dataTables.bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/select2.full.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/bootstrap-toggle.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/jquery.cookie.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/moment-with-locales.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.js"></script>
<!-- Javascript -->

<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/readmore.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/app.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/toastr.min.js"></script>
<script>
    <?php if(Session::has('message')): ?>
    var type = "<?php echo e(Session::get('alert-type', 'info')); ?>";
    switch (type) {
        case 'info':
            toastr.info("<?php echo e(Session::get('message')); ?>");
            break;

        case 'warning':
            toastr.warning("<?php echo e(Session::get('message')); ?>");
            break;

        case 'success':
            toastr.success("<?php echo e(Session::get('message')); ?>");
            break;

        case 'error':
            toastr.error("<?php echo e(Session::get('message')); ?>");
            break;
    }
    <?php endif; ?>
</script>
<?php echo $__env->yieldContent('javascript'); ?>
</body>
</html>
