<!DOCTYPE html>
<html>
<head>
    
    <title><?php echo $__env->yieldContent('page_title',Voyager::setting('admin_title') . " - " . Voyager::setting('admin_description')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?= csrf_token() ?>"/>
    <!-- Fonts -->
    <link href='https://fonts.googleapis.com/css?family=Roboto+Condensed:300,400|Lato:300,400,700,900' rel='stylesheet'
          type='text/css'>

    <!-- CSS Libs -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/animate.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/bootstrap-switch.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/checkbox3.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/dataTables.bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/select2.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/lib/css/toastr.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/bootstrap-toggle.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/js/icheck/icheck.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.css">
    <!-- CSS App -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(config('voyager.assets_path')); ?>/css/themes/flat-blue.css">

    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Roboto:300,400,500,300italic">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(config('voyager.assets_path')); ?>/images/logo-icon.png" type="image/x-icon">

    <!-- CSS Fonts -->
    <link rel="stylesheet" href="<?php echo e(config('voyager.assets_path')); ?>/fonts/voyager/styles.css">
    <script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.min.js"></script>
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.0/themes/smoothness/jquery-ui.css">
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.0/jquery-ui.min.js"></script>
    <script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/vue.min.js"></script>

    <?php echo $__env->yieldContent('css'); ?>

    <!-- Voyager CSS -->
    <link rel="stylesheet" href="<?php echo e(config('voyager.assets_path')); ?>/css/voyager.css">

    <?php echo $__env->yieldContent('head'); ?>

</head>

<body class="flat-blue">

<div id="voyager-loader">
    <?php $admin_loader_img = Voyager::setting('admin_loader', ''); ?>
    <?php if($admin_loader_img == ''): ?>
        <img src="<?php echo e(config('voyager.assets_path') . '/images/logo-icon.png'); ?>" alt="Voyager Loader">
    <?php else: ?>
        <img src="<?php echo e(Voyager::image($admin_loader_img)); ?>" alt="Voyager Loader">
    <?php endif; ?>
</div>

<?php
$user_avatar = Voyager::image(Auth::user()->avatar);
if ((substr(Auth::user()->avatar, 0, 7) == 'http://') || (substr(Auth::user()->avatar, 0, 8) == 'https://')) {
    $user_avatar = Auth::user()->avatar;
}
$menuExpanded = isset($_COOKIE['expandedMenu']) && $_COOKIE['expandedMenu'] == 1;
?>

<div class="app-container <?php if($menuExpanded): ?> expanded <?php endif; ?> ">
    <div class="row content-container">
        <nav class="navbar navbar-default navbar-fixed-top navbar-top">
            <div class="container-fluid">
                <div class="navbar-header">
                    <div class="hamburger <?php if($menuExpanded): ?> is-active <?php endif; ?> ">
                        <span class="hamburger-inner"></span>
                    </div>

                    <ol class="breadcrumb">
                        <?php if(count(Request::segments()) == 1): ?>
                            <li class="active"><i class="voyager-boat"></i> Dashboard</li>
                        <?php else: ?>
                            <li class="active">
                                <a href="<?php echo e(route('voyager.dashboard')); ?>"><i class="voyager-boat"></i> Dashboard</a>
                            </li>
                        <?php endif; ?>
                        <?php $breadcrumb_url = ''; ?>
                        <?php for($i = 1; $i <= count(Request::segments()); $i++): ?>
                            <?php $breadcrumb_url .= '/' . Request::segment($i); ?>
                            <?php if(Request::segment($i) != ltrim(route('voyager.dashboard', [], false), '/') && !is_numeric(Request::segment($i))): ?>

                                <?php if($i < count(Request::segments()) & $i > 0): ?>
                                    <li class="active"><a
                                                href="<?php echo e($breadcrumb_url); ?>"><?php echo e(ucwords(str_replace('-', ' ', str_replace('_', ' ', Request::segment($i))))); ?></a>
                                    </li>
                                <?php else: ?>
                                    <li><?php echo e(ucwords(str_replace('-', ' ', str_replace('_', ' ', Request::segment($i))))); ?></li>
                                <?php endif; ?>

                            <?php endif; ?>
                        <?php endfor; ?>
                    </ol>


                    <button type="button" class="navbar-right-expand-toggle pull-right visible-xs">
                        <i class="voyager-list icon"></i>
                    </button>
                </div>
                <ul class="nav navbar-nav navbar-right">
                    <button type="button" class="navbar-right-expand-toggle pull-right visible-xs">
                        <i class="voyager-x icon"></i>
                    </button>


                    <li class="dropdown profile">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button"
                           aria-expanded="false"><img src="<?php echo e($user_avatar); ?>" class="profile-img"> <span
                                    class="caret"></span></a>
                        <ul class="dropdown-menu dropdown-menu-animated">
                            <li class="profile-img">
                                <img src="<?php echo e($user_avatar); ?>" class="profile-img">
                                <div class="profile-body">
                                    <h5><?php echo e(Auth::user()->name); ?></h5>
                                    <h6><?php echo e(Auth::user()->email); ?></h6>
                                </div>
                            </li>
                            <li class="divider"></li>
                            <li>
                                <a href="<?php echo e(route('voyager.profile')); ?>"><i class="voyager-person"></i> Profile</a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('voyager.logout')); ?>"><i class="voyager-power"></i> Logout</a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>


        <div class="side-menu sidebar-inverse">
            <nav class="navbar navbar-default" role="navigation">
                <div class="side-menu-container">
                    <div class="navbar-header">
                        <a class="navbar-brand" href="<?php echo e(route('voyager.dashboard')); ?>">
                            <div class="logo-icon-container">
                                <?php $admin_logo_img = Voyager::setting('admin_icon_image', ''); ?>
                                <?php if($admin_logo_img == ''): ?>
                                    <img src="<?php echo e(config('voyager.assets_path')); ?>/images/logo-icon-light.png" alt="Logo Icon">
                                <?php else: ?>
                                    <img src="<?php echo e(Voyager::image($admin_logo_img)); ?>" alt="Logo Icon">
                                <?php endif; ?>
                            </div>
                            <div class="title"><?php echo e(Voyager::setting('admin_title', 'VOYAGER')); ?></div>
                        </a>
                        <button type="button" class="navbar-expand-toggle pull-right visible-xs">
                            <i class="voyager-x icon"></i>
                        </button>
                    </div><!-- .navbar-header -->

                    <div class="panel widget center bgimage"
                         style="background-image:url(<?php echo e(Voyager::image( Voyager::setting('admin_bg_image'), config('voyager.assets_path') . '/images/bg.jpg' )); ?>);">
                        <div class="dimmer"></div>
                        <div class="panel-content">
                            <img src="<?php echo e($user_avatar); ?>" class="avatar" alt="<?php echo e(Auth::user()->name); ?> avatar">
                            <h4><?php echo e(ucwords(Auth::user()->name)); ?></h4>
                            <p><?php echo e(Auth::user()->email); ?></p>

                            <a href="<?php echo e(route('voyager.profile')); ?>" class="btn btn-primary">Profile</a>
                            <div style="clear:both"></div>
                        </div>
                    </div>

                    <?= Menu::display('admin', 'admin_menu'); ?>
                </nav>
            </div>
            <!-- Main Content -->
            <div class="container-fluid">
                <div class="side-body padding-top">
                    <?php echo $__env->yieldContent('page_header'); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<footer class="app-footer">
    <div class="site-footer-right">
        <?php if(rand(1,100) == 100): ?>
            <i class="voyager-rum-1"></i> Made with rum and even more rum
        <?php else: ?>
            Made with <i class="voyager-heart"></i> by <a href="http://thecontrolgroup.com" target="_blank">The Control Group</a>
        <?php endif; ?>
        - <?php echo e(Voyager::getVersion()); ?>

    </div>
</footer>
<!-- Javascript Libs -->

<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/bootstrap-switch.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.matchHeight-min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/dataTables.bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/select2.full.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/bootstrap-toggle.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/jquery.cookie.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/moment-with-locales.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.js"></script>
<!-- Javascript -->

<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/readmore.min.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/js/app.js"></script>
<script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/toastr.min.js"></script>
<script>
    <?php if(Session::has('message')): ?>
    var type = "<?php echo e(Session::get('alert-type', 'info')); ?>";
    switch (type) {
        case 'info':
            toastr.info("<?php echo e(Session::get('message')); ?>");
            break;

        case 'warning':
            toastr.warning("<?php echo e(Session::get('message')); ?>");
            break;

        case 'success':
            toastr.success("<?php echo e(Session::get('message')); ?>");
            break;

        case 'error':
            toastr.error("<?php echo e(Session::get('message')); ?>");
            break;
    }
    <?php endif; ?>
</script>
<?php echo $__env->yieldContent('javascript'); ?>
</body>
</html>
