<?php $__env->startSection('css'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php if(isset($dataTypeContent->id)): ?>
    <?php $__env->startSection('page_title','Edit '.$dataType->display_name_singular); ?>
<?php else: ?>
    <?php $__env->startSection('page_title','Add '.$dataType->display_name_singular); ?>
<?php endif; ?>

<?php $__env->startSection('page_header'); ?>
    <h1 class="page-title">
        <i class="<?php echo e($dataType->icon); ?>"></i> <?php if(isset($dataTypeContent->id)): ?><?php echo e('Edit'); ?><?php else: ?><?php echo e('New'); ?><?php endif; ?> <?php echo e($dataType->display_name_singular); ?>

    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-content container-fluid">
        <div class="row">
            <div class="col-md-12">

                <div class="panel panel-bordered">

                    <div class="panel-heading">
                        <h3 class="panel-title"><?php if(isset($dataTypeContent->id)): ?><?php echo e('Edit'); ?><?php else: ?><?php echo e('Add New'); ?><?php endif; ?> <?php echo e($dataType->display_name_singular); ?></h3>
                    </div>
                    <!-- /.box-header -->
                    <!-- form start -->
                    <form role="form"
                          action="<?php if(isset($dataTypeContent->id)): ?><?php echo e(route('voyager.'.$dataType->slug.'.update', $dataTypeContent->id)); ?><?php else: ?><?php echo e(route('voyager.'.$dataType->slug.'.store')); ?><?php endif; ?>"
                          method="POST" enctype="multipart/form-data">
                        <!-- PUT Method if we are editing -->
                        <?php if(isset($dataTypeContent->id)): ?>
                            <?php echo e(method_field("PUT")); ?>

                        <?php endif; ?>

                        <!-- CSRF TOKEN -->
                        <?php echo e(csrf_field()); ?>


                        <div class="panel-body">

                            <?php if(count($errors) > 0): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <!-- If we are editing -->
                            <?php if(isset($dataTypeContent->id)): ?>
                                <?php $dataTypeRows = $dataType->editRows; ?>
                            <?php else: ?>
                                <?php $dataTypeRows = $dataType->addRows; ?>
                            <?php endif; ?>

                            <?php $__currentLoopData = $dataTypeRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                <?php $options = json_decode($row->details); $checked = false; ?>
                                <div class="form-group">
                                    <label for="name"><?php echo e($row->display_name); ?></label>

                                    <?php if($row->type == "text"): ?>
                                        <input type="text" class="form-control" name="<?php echo e($row->field); ?>"
                                               placeholder="<?php echo e($row->display_name); ?>"
                                               <?php echo isBreadSlugAutoGenerator($options); ?>

                                               value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php elseif(isset($options->default)): ?><?php echo e(old($row->field, $options->default)); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">
                                    <?php elseif($row->type == "password"): ?>
                                        <?php if(isset($dataTypeContent->{$row->field})): ?>
                                            <br>
                                            <small>Leave empty to keep the same</small>
                                        <?php endif; ?>
                                        <input type="password" class="form-control" name="<?php echo e($row->field); ?>" value="">
                                    <?php elseif($row->type == "text_area"): ?>
                                        <textarea class="form-control"
                                                  name="<?php echo e($row->field); ?>"><?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php elseif(isset($options->default)): ?><?php echo e(old($row->field, $options->default)); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?></textarea>
                                    <?php elseif($row->type == "rich_text_box"): ?>
                                        <textarea class="form-control richTextBox"
                                                  name="<?php echo e($row->field); ?>"><?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?></textarea>
                                    <?php elseif($row->type == "image" || $row->type == "file"): ?>
                                        <?php if($row->type == "image" && isset($dataTypeContent->{$row->field})): ?>
                                            <img src="<?php echo e(Voyager::image( $dataTypeContent->{$row->field} )); ?>"
                                                 style="width:200px; height:auto; clear:both; display:block; padding:2px; border:1px solid #ddd; margin-bottom:10px;">
                                        <?php elseif($row->type == "file" && isset($dataTypeContent->{$row->field})): ?>
                                            <div class="fileType"><?php echo e($dataTypeContent->{$row->field}); ?></div>
                                        <?php endif; ?>
                                        <input type="file" name="<?php echo e($row->field); ?>">
                                    <?php elseif($row->type == "select_dropdown"): ?>
                                        <?php 
                                            if(strpos($row->field, '_id')){
                                                $row->field = str_replace('_id', '', $row->field); 
                                                $hasId = true;
                                            }else{
                                                $row->field = snake_case($row->field);
                                                $hasId = false;
                                            }
                                        ?>

                                        <?php if(isset($options->relationship)): ?>


                                            <?php if( !method_exists( $dataType->model_name, $row->field ) ): ?>
                                                <p class="label label-warning"><i class="voyager-warning"></i> Make sure to setup the appropriate relationship in the <?php echo e($row->field . '()'); ?> method of the <?php echo e($dataType->model_name); ?> class.</p>
                                            <?php endif; ?>

                                            <?php if( method_exists( $dataType->model_name, $row->field ) ): ?>
                                                <?php if(isset($dataTypeContent->{$row->field}) && !is_null(old($row->field, $dataTypeContent->{$row->field}))): ?>
                                                    <?php $selected_value = old($row->field, $dataTypeContent->{$row->field}->{$options->relationship->key}); ?>
                                                <?php else: ?>
                                                    <?php $selected_value = old($row->field); ?>
                                                <?php endif; ?>

                                                <select class="form-control select2" name="<?php echo e(($hasId) ? snake_case($row->field).'_id' : snake_case($row->field)); ?>">
                                                    <?php $default = (isset($options->default) && !isset($dataTypeContent->{$row->field})) ? $options->default : NULL; ?>

                                                    <?php if(isset($options->options)): ?>
                                                        <optgroup label="Custom">
                                                        <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                            <option value="<?php echo e($key); ?>" <?php if($default == $key && $selected_value === NULL): ?><?php echo e('selected="selected"'); ?><?php endif; ?> <?php if((string)$selected_value == (string)$key): ?><?php echo e('selected="selected"'); ?><?php endif; ?>><?php echo e($option); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                                        </optgroup>
                                                    <?php endif; ?>
                                                    
                                                    <?php
                                                    $relationshipClass = $dataTypeContent->{$row->field}()->getRelated();
                                                    $relationshipOptions = $relationshipClass::all();

                                                    // Try to get default value for the relationship
                                                    // when default is a callable function (ClassName@methodName)
                                                    if ($default != NULL) {
                                                        $comps = explode('@', $default);
                                                        if (count($comps) == 2 && method_exists($comps[0], $comps[1])) {
                                                            $default = call_user_func([$comps[0], $comps[1]]);
                                                        }
                                                    }
                                                    ?>

                                                    <optgroup label="Relationship">
                                                    <?php $__currentLoopData = $relationshipOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relationshipOption): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                        <option value="<?php echo e($relationshipOption->{$options->relationship->key}); ?>" <?php if($default == $relationshipOption->{$options->relationship->key} && $selected_value === NULL): ?><?php echo e('selected="selected"'); ?><?php endif; ?> <?php if($selected_value == $relationshipOption->{$options->relationship->key}): ?><?php echo e('selected="selected"'); ?><?php endif; ?>><?php echo e($relationshipOption->{$options->relationship->label}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                                    </optgroup>
                                                </select>
                                            <?php else: ?>
                                                <select class="form-control select2" name="<?php echo e($row->field); ?>"></select>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php $selected_value = (isset($dataTypeContent->{$row->field}) && !is_null(old($row->field, $dataTypeContent->{$row->field}))) ? old($row->field, $dataTypeContent->{$row->field}) : old($row->field); ?>
                                            <select class="form-control select2" name="<?php echo e($row->field); ?>">
                                                <?php $default = (isset($options->default) && !isset($dataTypeContent->{$row->field})) ? $options->default : NULL; ?>
                                                <?php if(isset($options->options)): ?>
                                                    <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                        <option value="<?php echo e($key); ?>" <?php if($default == $key && $selected_value === NULL): ?><?php echo e('selected="selected"'); ?><?php endif; ?> <?php if($selected_value == $key): ?><?php echo e('selected="selected"'); ?><?php endif; ?>><?php echo e($option); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        <?php endif; ?>

                                    <?php elseif($row->type == "select_multiple"): ?>
                                        
                                        <?php if(isset($options->relationship) && !method_exists( $dataType->model_name, $row->field ) ): ?>
                                            <p class="label label-warning"><i class="voyager-warning"></i> Make sure to setup the appropriate relationship in the <?php echo e($row->field . '()'); ?> method of the <?php echo e($dataType->model_name); ?> class.</p>
                                        <?php endif; ?>

                                        <select class="form-control select2" name="<?php echo e($row->field); ?>[]" multiple>
                                            <?php if(isset($options->relationship)): ?>
                                                
                                                <?php if( method_exists( $dataType->model_name, $row->field ) ): ?>
                                                    <?php $selected_values = isset($dataTypeContent) ? $dataTypeContent->{$row->field}()->pluck($options->relationship->key)->all() : array(); ?>
                                                    <?php $relationshipClass = get_class(app($dataType->model_name)->{$row->field}()->getRelated()); ?>
                                                    <?php $relationshipOptions = $relationshipClass::all(); ?>
                                                    <?php $__currentLoopData = $relationshipOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relationshipOption): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

                                                    <?php 
                                                        if(strpos($options->relationship->key, '.'))
                                                        {
                                                            list(,$key) = explode('.', $options->relationship->key);
                                                        }else{
                                                            $key = $options->relationship->key;
                                                        }

                                                    ?>
                                                        <option value="<?php echo e($relationshipOption->{$key}); ?>" <?php if(in_array($relationshipOption->{$key}, $selected_values)): ?><?php echo e('selected="selected"'); ?><?php endif; ?>><?php echo e($relationshipOption->{$options->relationship->label}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                                <?php endif; ?>
                                            <?php elseif(isset($options->options)): ?>
                                                <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                        <?php $selected = ''; ?>
                                                    <?php if(is_array($dataTypeContent->{$row->field}) && in_array($key, $dataTypeContent->{$row->field})): ?>
                                                        <?php $selected = 'selected="selected"'; ?>
                                                    <?php endif; ?>
                                                    <option value="<?php echo e($key); ?>" <?php echo $selected; ?>>
                                                        <?php echo e($label); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                            <?php endif; ?>
                                        </select>

                                    <?php elseif($row->type == "radio_btn"): ?>
                                        <?php $selected_value = (isset($dataTypeContent->{$row->field}) && !empty(old($row->field,
                                                        $dataTypeContent->{$row->field}))) ? old($row->field,
                                                $dataTypeContent->{$row->field}) : old($row->field); ?>
                                        <?php $default = (isset($options->default) && !isset($dataTypeContent->{$row->field})) ? $options->default : NULL; ?>
                                        <ul class="radio">
                                            <?php if(isset($options->options)): ?>
                                                <?php $__currentLoopData = $options->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                                    <li>
                                                        <input type="radio" id="option-<?php echo e($key); ?>"
                                                               name="<?php echo e($row->field); ?>"
                                                               value="<?php echo e($key); ?>" <?php if($default == $key && $selected_value === NULL): ?><?php echo e('checked'); ?><?php endif; ?> <?php if($selected_value == $key): ?><?php echo e('checked'); ?><?php endif; ?>>
                                                        <label for="option-<?php echo e($key); ?>"><?php echo e($option); ?></label>
                                                        <div class="check"></div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                                            <?php endif; ?>
                                        </ul>

                                    <?php elseif($row->type == "checkbox"): ?>
                                        <br>
                                        <?php $checked = false; ?>
                                        <?php if(isset($dataTypeContent->{$row->field}) || old($row->field)): ?>
                                         <?php $checked = old($row->field, $dataTypeContent->{$row->field}); ?>
                                        <?php else: ?>
                                         <?php $checked = isset($options->checked) && $options->checked ? true : false; ?>
                                        <?php endif; ?>

                                        <?php if(isset($options->on) && isset($options->off)): ?>
                                            <input type="checkbox" name="<?php echo e($row->field); ?>" class="toggleswitch"
                                                   data-on="<?php echo e($options->on); ?>" <?php echo $checked ? 'checked="checked"' : ''; ?>

                                                   data-off="<?php echo e($options->off); ?>">
                                        <?php else: ?>
                                            <input type="checkbox" name="<?php echo e($row->field); ?>" class="toggleswitch"
                                                   <?php if($checked): ?> checked <?php endif; ?>>
                                        <?php endif; ?>

                                    <?php elseif($row->type == "timestamp"): ?>
                                        <input type="datetime" class="form-control datepicker" name="<?php echo e($row->field); ?>"
                                                value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(gmdate('m/d/Y g:i A', strtotime(old($row->field, $dataTypeContent->{$row->field})))); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">

                                    <?php elseif($row->type == "date"): ?>
                                        <input type="date" class="form-control" name="<?php echo e($row->field); ?>"
                                               placeholder="<?php echo e($row->display_name); ?>"
                                               value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(gmdate('Y-m-d', strtotime(old($row->field, $dataTypeContent->{$row->field})))); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">

                                    <?php elseif($row->type == "date-time"): ?>
                                        <input type="datetime-local" class="form-control" name="<?php echo e($row->field); ?>"
                                               placeholder="<?php echo e($row->display_name); ?>"
                                               value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(gmdate('Y-m-d\TH:i:s', strtotime(old($row->field, $dataTypeContent->{$row->field})))); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">

                                    <?php elseif($row->type == "number"): ?>
                                        <input type="number" class="form-control" name="<?php echo e($row->field); ?>"
                                               placeholder="<?php echo e($row->display_name); ?>"
                                               value="<?php if(isset($dataTypeContent->{$row->field})): ?><?php echo e(old($row->field, $dataTypeContent->{$row->field})); ?><?php else: ?><?php echo e(old($row->field)); ?><?php endif; ?>">

                                    <?php endif; ?>
                                    
                                    <?php if(isset($options->description)): ?>
                                    <i class="help-block"><span class="voyager-info-circled"></span> <?php echo e($options->description); ?></i>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

                        </div><!-- panel-body -->

                        <div class="panel-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>

                    <iframe id="form_target" name="form_target" style="display:none"></iframe>
                    <form id="my_form" action="<?php echo e(route('voyager.upload')); ?>" target="form_target" method="post"
                          enctype="multipart/form-data" style="width:0;height:0;overflow:hidden">
                        <input name="image" id="upload_file" type="file"
                               onchange="$('#my_form').submit();this.value='';">
                        <input type="hidden" name="type_slug" id="type_slug" value="<?php echo e($dataType->slug); ?>">
                        <?php echo e(csrf_field()); ?>

                    </form>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $('document').ready(function () {
            $('.toggleswitch').bootstrapToggle();

            $('.side-body input[data-slug-origin]').each(function(i, el) {
                $(el).slugify();
            });
        });
    </script>
    <script src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/tinymce/tinymce.min.js"></script>
    <script src="<?php echo e(config('voyager.assets_path')); ?>/js/voyager_tinymce.js"></script>
    <script src="<?php echo e(config('voyager.assets_path')); ?>/js/slugify.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>